//***************************************************************************************
// AnimationHelper.h by Frank Luna (C) 2011 All Rights Reserved.
//
// Contains classes for defining keyframes and animation.
//***************************************************************************************

#ifndef ANIMATION_HELPER_H
#define ANIMATION_HELPER_H

#include "../../Common/d3dUtil.h"

///<summary>
/// A Keyframe defines the bone transformation at an instant in time.
///</summary>
struct Keyframe
{
	Keyframe();
	~Keyframe();

    float TimePos;
	DirectX::XMFLOAT3 Translation;
    DirectX::XMFLOAT3 Scale;
    DirectX::XMFLOAT4 RotationQuat;
};

///<summary>
/// A BoneAnimation is defined by a list of keyframes.  For time
/// values inbetween two keyframes, we interpolate between the
/// two nearest keyframes that bound the time.  
///
/// We assume an animation always has two keyframes.
///</summary>
struct BoneAnimation
{
	float GetStartTime()const;
	float GetEndTime()const;

    void Interpolate(float t, DirectX::XMFLOAT4X4& M)const;

	std::vector<Keyframe> Keyframes; 	

};

#endif // ANIMATION_HELPER_H